import { Role } from "@prisma/client";
import { NextResponse } from "next/server";
import { prisma } from "@/lib/prisma";
import { requireRole } from "@/lib/rbac";

export const dynamic = "force-dynamic";

export async function PATCH(req: Request, { params }: { params: { id: string } }) {
  const guard = await requireRole([Role.ADMIN]);
  if (guard.error || !guard.session) return guard.error;

  const { role } = await req.json();
  if (!Object.values(Role).includes(role)) {
    return NextResponse.json({ error: "Geçersiz rol" }, { status: 400 });
  }

  await prisma.user.update({ where: { id: params.id }, data: { role } });

  await prisma.auditLog.create({
    data: {
      actorId: guard.session.sub,
      action: "USER_ROLE_UPDATED",
      target: params.id,
      description: `User role set to ${role}`
    }
  });

  return NextResponse.json({ ok: true });
}
